<?php

namespace Modules\Support\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Support\Entities\Ticket;

class TicketController extends Controller
{
    public function index()
    {
        $tickets = Ticket::latest()->paginate(10);
        return view('support::tickets.index', compact('tickets'));
    }

    public function create()
    {
        return view('support::tickets.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'question' => 'required|string',
            'answer' => 'nullable|string',
        ]);

        Ticket::create($data);

return redirect()->route('admin.tickets.index')->with('success', 'تم التعديل بنجاح');
    }

    public function edit(Ticket $ticket)
    {
        return view('support::tickets.edit', compact('ticket'));
    }

    public function update(Request $request, Ticket $ticket)
    {
        $data = $request->validate([
            'question' => 'required|string',
            'answer' => 'nullable|string',
        ]);

        $ticket->update($data);

        return redirect()->route('admin.tickets.index')->with('success', 'تم التعديل بنجاح');
    }

    public function destroy(Ticket $ticket)
    {
        $ticket->delete();
        return redirect()->back()->with('success', 'تم الحذف بنجاح');
    }
}
