<?php

namespace Modules\Support\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->routes(function () {
            // API routes
            Route::prefix('api')
                ->middleware('api')
                ->namespace('Modules\Support\Http\Controllers\Api')
                ->group(module_path('Support', '/Routes/api.php'));

            // Web routes
            Route::middleware('web')
                ->namespace('Modules\Support\Http\Controllers')
                ->group(module_path('Support', '/Routes/web.php'));
        });
    }
}
