<?php

namespace Modules\Support\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;

class SupportServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // تسجيل المسار alias للـ views
        $this->loadViewsFrom(module_path('Support', 'Resources/views'), 'support');

        // تسجيل ملفات الترجمة إذا أردت
        $this->loadTranslationsFrom(module_path('Support', 'Resources/lang'), 'support');

        // تسجيل المايجريشن
        $this->loadMigrationsFrom(module_path('Support', 'Database/Migrations'));
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
