@extends('layouts.app')

@section('title', 'قائمة الأسئلة')

@section('content')
    <div class="container">
        <br><br><br>
        <h1>الأسئلة</h1>
        <a href="{{ route('admin.tickets.create') }}" class="btn btn-primary">إضافة سؤال جديد</a>

        <table class="table table-bordered mt-3">
            <thead>
                <tr>
                    <th>#</th>
                    <th>السؤال</th>
                    <th>الجواب</th>
                    <th>الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($tickets as $ticket)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $ticket->question }}</td>
                        <td>{{ $ticket->answer }}</td>
                        <td>
                            <a href="{{ route('admin.tickets.edit', $ticket->id) }}" class="btn btn-sm btn-warning">تعديل</a>
                            <a href="{{ route('admin.tickets.edit', $ticket->id) }}" class="btn btn-sm btn-success">عرض</a>
                            <form action="{{ route('admin.tickets.destroy', $ticket->id) }}" method="POST" style="display:inline-block;">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد؟')">حذف</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection
